﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultPerformancePlugin.Controls.Strategy;

namespace WinfootDefaultPerformancePlugin.Controls
{
    public partial class EnablePrefetcher : UserControl, ICorrespondenceOS, IControl
    {

        private EnablePrefetcherController enablePrefetcherController;

        public EnablePrefetcher()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
#if DEBUG
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.migiside.net/wiki/doku.php?id=plugin:performance:enableprefetcher"));
                userHelp.Show();
            }
        }

        public void SetEnablePrefetcherValue(int i)
        {
            switch (i)
            {
                case 0:
                    radioButton1.Checked = true;
                    break;
                case 1:
                    radioButton2.Checked = true;
                    break;
                case 2:
                    radioButton3.Checked = true;
                    break;
                default:
                    radioButton4.Checked = true;
                    break;
            }
        }


        public int GetEnablePrefetcherValue()
        {
            if (radioButton1.Checked)
            {
                return 0;
            }
            if (radioButton2.Checked)
            {
                return 1;
            }
            if (radioButton3.Checked)
            {
                return 2;
            }
            return 3;
        }

        #region IControl メンバ

        public void Apply()
        {
            enablePrefetcherController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return enablePrefetcherController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList
        {
            get;
            set;
        }

        #endregion

        private void EnablePrefetcher_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            enablePrefetcherController = new EnablePrefetcherController(this,
                                                                                    (IEnablePrefetcherStrategy)
                                                                                    wfUtillity.GetCorrespondenceInstance
                                                                                        (new List<ICorrespondenceOS>
                                                                                             {
                                                                                                 new EnablePrefetcherDefaultStrategy()
                                                                                             }));
            enablePrefetcherController.Read();
        }
    }
}
